/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: OS_WinCE_HWFunctions.c $
   Last Modification:
    $Author: Robert $
    $Modtime: 28.04.09 14:49 $
    $Revision: 2805 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: no
     WinCE        : no
 
   Description:
     Demo implementation of OS specific CIFX Hardware functions
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     
**************************************************************************************/

#include "cifXHWFunctions.h"
#include "OS_Includes.h"
#include "OS_Dependent.h"

/* Error & Type Def. */
#include "CIFXErrors.h"

/* general device functions */
#include "DEV_InterfaceUser.h"
#include "DEV_FileUser.h"

#include "DevStruct.h"

#define                   DEMO_DPM_BUS_ADDR     0x26000000
#define                   DEMO_DPM_SIZE         0x10000
#define                   DEMO_DPM_IRQ          0x0F         
#define                   DEMO_DPM_SYSINTR      0x1F

#define                   BOARD_NO              0     /* Just use the first Board we found */

/* global device driver structure */
CIFXCEDRV_DEVICEINSTANCE  g_tDrvDevInst;
int                       g_fIRQEnable = 1;

/*****************************************************************************/
/*! Gets a pointer to the first board from the cifX driver and stores it
*   in global variables.
*   \return true on success                                                  */
/*****************************************************************************/
BOOL cifXGetMemptr( uint8_t** ppbDPM, uint32_t* pulDPMSize, unsigned long ulBoardIdx)
{
  int                       fRet      = TRUE;
  unsigned long             ulBusAddr = DEMO_DPM_BUS_ADDR;
  unsigned long             ulDPMSize = DEMO_DPM_SIZE;
  PCIFXCEDRV_DEVICEINSTANCE ptDrvDevInst = NULL;

  ptDrvDevInst = &g_tDrvDevInst;
  
  OS_Memset(ptDrvDevInst,0, sizeof(CIFXCEDRV_DEVICEINSTANCE));

  if(NULL == ptDrvDevInst)
  {
    fRet = FALSE;
  } else 
  {
    PHYSICAL_ADDRESS tTransAddress = {0};
    PHYSICAL_ADDRESS tBusAddress   = {0};
    ULONG            ulAddrSpace   = 0;

    tBusAddress.QuadPart = ulBusAddr;
    if(!HalTranslateBusAddress(Isa, 0, tBusAddress, &ulAddrSpace, &tTransAddress))
    {
      fRet = FALSE;
    } else
    {
      PHYSICAL_ADDRESS tAddr = {0};

      tAddr.QuadPart                               = ptDrvDevInst->tDevInstance.ulPhysicalAddress;
      ptDrvDevInst->tDevInstance.fPCICard          = FALSE;
      ptDrvDevInst->tDevInstance.ulPhysicalAddress = tTransAddress.LowPart;

      ptDrvDevInst->tIsrInfo.cbSize       = sizeof(ptDrvDevInst->tIsrInfo);
      ptDrvDevInst->tIsrInfo.dwIrq        = DEMO_DPM_IRQ;
      ptDrvDevInst->tIsrInfo.dwSysintr    = DEMO_DPM_SYSINTR;

      
      /* set DPM pointer and size */
      *pulDPMSize = ulDPMSize;
      *ppbDPM     = (unsigned char*)MmMapIoSpace(tAddr, *pulDPMSize, FALSE);
      

      ptDrvDevInst->tDevInstance.ulDPMSize = *pulDPMSize;
      ptDrvDevInst->tDevInstance.pbDPM     = *ppbDPM;
    }
  } 
  return fRet;
}


/*****************************************************************************/
/*! removes the allocated DPM pointer
*   This function needs to be adapted for own needs
*
*   \return true on success                                                  */
/*****************************************************************************/
void cifXReleaseMemptr(void)
{
  /* !!! TODO:                                                                  !!! */
  /* ...                                                                             */
  /* !!! place code to release used resources here !!!                               */  

}

/*****************************************************************************/
/*! Retrieves a pointer to the DPM
*   This function needs to be adapted for own needs
*
*   \return true on success                                                  */
/*****************************************************************************/
int cifXTkHWFunctions_GetDPMPointer( uint8_t** ppbDPM, uint32_t* pulDPMSize)
{
  int fRet = 0;

  /* !!! TODO: replace the the function call -cifXGetMemptr()- with own code !!! */
  /* ...                                                                         */
  /* !!! place code to configure or map the DPM pointer here !!!                 */  

  fRet = cifXGetMemptr(  ppbDPM, pulDPMSize, BOARD_NO) ? 1 : 0;

  return fRet;
}

/*****************************************************************************/
/*! Retrieves a pointer to the DPM
*   This function needs to be adapted for own needs
*
*   \return true on success                                                  */
/*****************************************************************************/
void cifXTkHWFunctions_FreeDPMPointer( uint8_t* pbDPM)
{
  /* !!! TODO: replace the the function call -cifXReleaseMemptr()- with own code !!! */
  /* ...                                                                             */
  /* !!! place code to unconfigure or unmap the DPM pointer here !!!                 */  

  if( NULL != pbDPM)
    cifXReleaseMemptr();
}

int32_t cifXHWSample(void);

/*****************************************************************************/
/*! Main routine
 * \param argc
 * \param argv
 * \return 0 on success                                                      */
/*****************************************************************************/
int main(void)
{
	return cifXHWSample();
}
